'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { cn } from '@/lib/utils';
import {
  LayoutDashboard,
  Fuel,
  ShoppingCart,
  Users,
  TrendingUp,
  Database,
  Settings,
  AlertTriangle,
  Building2,
  Package,
  ShoppingBag,
} from 'lucide-react';

const navigation = [
  { name: 'Dashboard', href: '/', icon: LayoutDashboard },
  { name: 'Ventes Carburant', href: '/sales', icon: Fuel },
  { name: 'Stocks & Cuves', href: '/stocks', icon: Database },
  { name: 'Shop', href: '/shop', icon: ShoppingCart },
  { name: 'Articles', href: '/products', icon: Package },
  { name: 'Achats', href: '/purchases', icon: ShoppingBag },
  { name: 'Clients', href: '/customers', icon: Users },
  { name: 'Fournisseurs', href: '/suppliers', icon: Building2 },
  { name: 'Analytics', href: '/analytics', icon: TrendingUp },
  { name: 'Alertes', href: '/alerts', icon: AlertTriangle },
  { name: 'Paramètres', href: '/settings', icon: Settings },
];

export default function Sidebar() {
  const pathname = usePathname();

  return (
    <div className="flex h-screen w-64 flex-col border-r bg-card">
      {/* Logo */}
      <div className="flex h-16 items-center border-b px-6">
        <Fuel className="h-8 w-8 text-primary" />
        <span className="ml-2 text-xl font-bold">Station Analytics</span>
      </div>

      {/* Navigation */}
      <nav className="flex-1 space-y-1 px-3 py-4">
        {navigation.map((item) => {
          const Icon = item.icon;
          const isActive = pathname === item.href;

          return (
            <Link
              key={item.name}
              href={item.href}
              className={cn(
                'flex items-center gap-3 rounded-lg px-3 py-2 text-sm font-medium transition-colors',
                isActive
                  ? 'bg-primary text-primary-foreground'
                  : 'text-muted-foreground hover:bg-accent hover:text-accent-foreground'
              )}
            >
              <Icon className="h-5 w-5" />
              {item.name}
            </Link>
          );
        })}
      </nav>

      {/* Footer */}
      <div className="border-t p-4">
        <div className="text-xs text-muted-foreground">
          <p>Version 1.0.0</p>
          <p className="mt-1">© 2024 Station Service</p>
        </div>
      </div>
    </div>
  );
}
