import { NextResponse } from 'next/server';
import connectDB from '@/lib/mongodb';
import { Pump } from '@/models';

/**
 * GET /api/pumps
 * Retourne toutes les pompes actives
 */
export async function GET() {
  try {
    await connectDB();

    const pumps = await Pump.find({ active: true })
      .select('pumpCode location fuelTypes cumulativeCounter')
      .lean();

    return NextResponse.json({
      success: true,
      data: pumps,
    });
  } catch (error) {
    console.error('Erreur API Pumps:', error);
    return NextResponse.json(
      {
        success: false,
        error: 'Erreur lors de la récupération des pompes',
      },
      { status: 500 }
    );
  }
}
