import { NextResponse } from 'next/server';
import dbConnect from '@/lib/mongodb';
import { PumpTransaction, POSTransaction, Customer } from '@/models';

export async function GET() {
  try {
    await dbConnect();

    // Statistiques clients (mock - nécessite vraies données)
    const customers = [
      {
        customerId: 'CUST-001',
        loyaltyCardId: 'LC-1001',
        firstName: 'Jean',
        lastName: 'Dupont',
        segment: 'VIP',
        registrationDate: '2024-01-15',
        fuelTxCount: 45,
        shopTxCount: 32,
        totalSpent: 2850.5,
        totalFuelLiters: 1250.0,
        avgTxPerMonth: 8.5,
        lastVisitDate: '2024-11-08',
        daysSinceLastVisit: 2,
        status: 'ACTIVE' as const,
      },
      {
        customerId: 'CUST-002',
        loyaltyCardId: 'LC-1002',
        firstName: 'Marie',
        lastName: 'Martin',
        segment: 'GOLD',
        registrationDate: '2024-02-20',
        fuelTxCount: 28,
        shopTxCount: 18,
        totalSpent: 1650.0,
        totalFuelLiters: 780.0,
        avgTxPerMonth: 5.2,
        lastVisitDate: '2024-11-05',
        daysSinceLastVisit: 5,
        status: 'ACTIVE' as const,
      },
      {
        customerId: 'CUST-003',
        loyaltyCardId: 'LC-1003',
        firstName: 'Pierre',
        lastName: 'Bernard',
        segment: 'SILVER',
        registrationDate: '2024-03-10',
        fuelTxCount: 15,
        shopTxCount: 8,
        totalSpent: 890.0,
        totalFuelLiters: 420.0,
        avgTxPerMonth: 3.1,
        lastVisitDate: '2024-10-15',
        daysSinceLastVisit: 26,
        status: 'AT_RISK' as const,
      },
      {
        customerId: 'CUST-004',
        loyaltyCardId: 'LC-1004',
        firstName: 'Sophie',
        lastName: 'Dubois',
        segment: 'VIP',
        registrationDate: '2023-11-05',
        fuelTxCount: 52,
        shopTxCount: 40,
        totalSpent: 3250.0,
        totalFuelLiters: 1580.0,
        avgTxPerMonth: 7.8,
        lastVisitDate: '2024-11-09',
        daysSinceLastVisit: 1,
        status: 'ACTIVE' as const,
      },
      {
        customerId: 'CUST-005',
        loyaltyCardId: 'LC-1005',
        firstName: 'Luc',
        lastName: 'Moreau',
        segment: 'SILVER',
        registrationDate: '2024-04-22',
        fuelTxCount: 8,
        shopTxCount: 3,
        totalSpent: 450.0,
        totalFuelLiters: 210.0,
        avgTxPerMonth: 1.8,
        lastVisitDate: '2024-08-20',
        daysSinceLastVisit: 82,
        status: 'CHURNED' as const,
      },
    ];

    const stats = {
      totalCustomers: customers.length,
      activeCustomers: customers.filter(c => c.status === 'ACTIVE').length,
      atRiskCustomers: customers.filter(c => c.status === 'AT_RISK').length,
      churnedCustomers: customers.filter(c => c.status === 'CHURNED').length,
      avgSpentPerCustomer: customers.reduce((sum, c) => sum + c.totalSpent, 0) / customers.length,
      avgVisitFrequency: customers.reduce((sum, c) => sum + c.avgTxPerMonth, 0) / customers.length,
    };

    const segments = [
      { segment: 'VIP', count: 2, revenue: 6100.5, avgSpent: 3050.25 },
      { segment: 'GOLD', count: 1, revenue: 1650.0, avgSpent: 1650.0 },
      { segment: 'SILVER', count: 2, revenue: 1340.0, avgSpent: 670.0 },
    ];

    return NextResponse.json({
      customers,
      stats,
      segments,
    });
  } catch (error) {
    console.error('Error fetching customer loyalty:', error);
    return NextResponse.json(
      { error: 'Failed to fetch customer loyalty data' },
      { status: 500 }
    );
  }
}
