# Station Service Analytics - Next.js AppThis is a [Next.js](https://nextjs.org) project bootstrapped with [`create-next-app`](https://nextjs.org/docs/app/api-reference/cli/create-next-app).



Application web moderne pour l'analytics et la gestion d'une station-service, construite avec Next.js 15, TypeScript, MongoDB et Shadcn UI.## Getting Started



## 🚀 FonctionnalitésFirst, run the development server:



### Dashboard Principal```bash

- **KPIs en temps réel**: CA, volumes, transactions, panier moyennpm run dev

- **Graphiques interactifs**: Évolution des ventes, répartition par carburant# or

- **Analyse par mode de paiement**: Espèces, CB, Mobile, Carte flottesyarn dev

# or

### Gestion des Stockspnpm dev

- **Monitoring cuves en temps réel**: Niveaux, températures, jauges visuelles# or

- **Alertes automatiques**: Stock critique, stock basbun dev

- **Calcul d'autonomie**: Jours de stock restants basé sur consommation moyenne```

- **Réconciliation quotidienne**: Détection d'écarts et fuites potentielles

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

### Analytics Ventes

- **Ventes quotidiennes par carburant**You can start editing the page by modifying `app/page.tsx`. The page auto-updates as you edit the file.

- **Performance par pompe**

- **Tendances et saisonnalité**This project uses [`next/font`](https://nextjs.org/docs/app/building-your-application/optimizing/fonts) to automatically optimize and load [Geist](https://vercel.com/font), a new font family for Vercel.

- **Analyse des prix**

## Learn More

### Clients & Fidélité

- **Suivi clients fidélité**To learn more about Next.js, take a look at the following resources:

- **Segmentation RFM**

- **Analyse comportementale**- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.

- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

## 🛠️ Stack Technique

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js) - your feedback and contributions are welcome!

- **Framework**: Next.js 15 (App Router)

- **Language**: TypeScript## Deploy on Vercel

- **Base de données**: MongoDB avec Mongoose

- **UI**: Shadcn UI + Tailwind CSSThe easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

- **Charts**: Recharts

- **Icons**: Lucide ReactCheck out our [Next.js deployment documentation](https://nextjs.org/docs/app/building-your-application/deploying) for more details.


## 📦 Installation

### Prérequis

- Node.js 18+ 
- MongoDB 5.0+
- npm

### Étapes

1. **Installer les dépendances**
```bash
npm install
```

2. **Configurer l'environnement**
```bash
cp .env.local.example .env.local
```

Éditer `.env.local` et configurer:
```env
MONGODB_URI=mongodb://localhost:27017/station-service
```

3. **Démarrer MongoDB**
```bash
# Windows
mongod

# Linux/Mac
sudo systemctl start mongod
```

4. **Lancer l'application**
```bash
npm run dev
```

Ouvrir [http://localhost:3000](http://localhost:3000)

## 📊 Import des Données

### Générer des données de test

Utiliser le script Python de génération (dans `../database/sample_data`):
```bash
cd ../database/sample_data
python generate_sample_data.py --days 90
```

### Importer dans MongoDB

```bash
mongoimport --db station-service --collection pumptransactions --type csv --file pumps_tx.csv --headerline
mongoimport --db station-service --collection tankreadings --type csv --file tank_readings.csv --headerline
mongoimport --db station-service --collection deliveries --type csv --file deliveries.csv --headerline
mongoimport --db station-service --collection postransactions --type csv --file pos_tx.csv --headerline
```

## 🏗️ Structure du Projet

```
nextjs-app/
├── src/
│   ├── app/                    # Pages & Routes (App Router)
│   │   ├── api/               # API Routes
│   │   │   ├── dashboard/
│   │   │   ├── stocks/
│   │   │   ├── sales/
│   │   │   └── pumps/
│   │   ├── stocks/            # Page Stocks
│   │   ├── layout.tsx
│   │   └── page.tsx           # Dashboard principal
│   ├── components/
│   │   ├── ui/                # Composants Shadcn
│   │   ├── layout/            # Header, Sidebar
│   │   ├── dashboard/         # StatCard, etc.
│   │   └── charts/            # Graphiques Recharts
│   ├── models/                # Schemas Mongoose
│   └── lib/
│       ├── mongodb.ts         # Connexion MongoDB
│       └── utils.ts
├── .env.local
└── package.json
```

## 🔌 API Routes

### Dashboard
- `GET /api/dashboard/overview?days=30` - KPIs globaux

### Stocks
- `GET /api/stocks/status` - État actuel des cuves
- `GET /api/stocks/reconciliation?days=7` - Réconciliation quotidienne

### Ventes
- `GET /api/sales/daily?days=30` - Ventes quotidiennes par carburant

### Pompes
- `GET /api/pumps/performance?days=7` - Performance par pompe

## 🚀 Déploiement

### Vercel
```bash
npm install -g vercel
vercel deploy
```

### Docker
```bash
docker build -t station-analytics .
docker run -p 3000:3000 station-analytics
```

## 📄 Licence

MIT
